<?php
    include("../../liblist.php");
    $GLOBALS['ConnIntra'] = ConnIntra();
    $GLOBALS['Conn'] = Connect();
    $logDir = "./logs/";
    $logfileName = "Problamiento TB_JOB_FILTROS ".date('dmYHis').".txt";
    $fullFileName = $logDir . $logfileName;

    echo 'Creando archivo de registro de proceso: ' . $logfileName, PHP_EOL;
    $logfile = fopen($fullFileName, "a") or die("Error creando archivo " . $logfileName);
    $_SESSION['logfile'] = $logfile;
    fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tInicio de proceso mensual\r\n") or die("Error escribiendo en el archivo\r\n");

    JobSaveDataFiltros();
   

    fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tProceso finalizado") or die("Error escribiendo en el archivo");
    fclose($_SESSION['logfile']);

    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    /*                                                                                                                                                                                                                                                                                              */
    /*                                                                                                                            Error Handler                                                                                                                                       */
    /*                                                                                                                                                                                                                                                                                              */
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

    set_error_handler('exceptions_error_handler');

    function exceptions_error_handler($severity, $message, $filename, $lineno) {
        if (error_reporting() == 0) {
            return;
        }
        if (error_reporting() & $severity) {
            $mensaje = "Severidad: ".$severity."\r\n\t\t\t\t";
            $mensaje .= "Archivo: ".$filename."\r\n\t\t\t\t";
            $mensaje .= "L�nea Nro.: ".$lineno."\r\n\t\t\t\t";
            $mensaje .= "Error: ".$message;
            fwrite($_SESSION['logfile'] , "".date("d/m/Y H:i:s")." -\t".$mensaje."\r\n") or die("Error escribiendo en el archivo\r\n");
            echo $mensaje, PHP_EOL;
        }
    }

    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    /*                                                                                                                                                                                                                                                                                              */
    /*                                                                                                                      Actualiza Tabla Tb_job_Filtros                                                                                                                              */
    /*                                                                                                                                                                                                                                                                                              */
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    

    function JobSaveDataFiltros(){
        $fecha = date('Y-m-d');  // Formato: AAAA-MM-DD
        $hora = date('H:i:s'); 
        try {

            $tsql = "WITH ProjectedStock AS (
                SELECT
                    itm.ItemCode AS ItemCode,
                    itm.ItemName AS ItemName,
                    SUM(DISTINCT whs.OnHand) AS StockBodegasActivas,
                    COALESCE(SUM(DISTINCT wor.PlannedQty - wor.CmpltQty), 0) AS Pendiente,
                    SUM(DISTINCT whs.OnHand) + COALESCE(SUM(DISTINCT wor.PlannedQty - wor.CmpltQty), 0) AS StockProyectado,
                    SUM(DISTINCT CASE WHEN manual.BufferVTA = 0 THEN vta.BufferVta ELSE manual.BufferVTA END) AS Buffer
            
                FROM
                    OITM itm
                    LEFT JOIN BufferVta vta ON vta.ItemCode = itm.ITEMCODE
                    LEFT JOIN OITW whs ON whs.ItemCode = itm.ITEMCODE AND whs.WhsCode IN ('1', '97')
                    LEFT JOIN OWOR wor ON wor.ItemCode = itm.ITEMCODE AND wor.status = 'R'
                    LEFT JOIN BufferVTA_Manual manual ON itm.ITEMCODE = manual.itemcode
                WHERE
                    itm.ValidFor = 'Y'
                    AND itm.U_Nivel1 IN (170, 100)
                    AND (itm.U_BAJA IS NULL OR itm.U_BAJA = 'N')
                GROUP BY
                    itm.ItemCode,
                    itm.ItemName
            )
            
            SELECT
                ItemCode,
                ItemName,
                StockBodegasActivas,
                Pendiente,
                StockProyectado,
                CASE 
                    WHEN Buffer IS NULL OR Buffer = 0 THEN 0.1
                    ELSE Buffer
                END AS [Buffer]
            
            FROM
                ProjectedStock;
            ";
          
            $params = array();
            $options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
            $stmt = sqlsrv_query($GLOBALS['Conn'], $tsql , $params, $options );
            
            while ($fila = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC)){
                $busca = "SELECT*,(CEIL(((ciclo_produccion * factor_fab) * ".$fila['Buffer'].") / und_redondeo) * und_redondeo) AS UnidadesRecomendadas, ((( ".$fila['StockProyectado']." / ".$fila['Buffer']." ) - punto_activacion )* 21) as DiasActivacion, now() FROM tb_plan_parametros WHERE itemcode = ".$fila['ItemCode'];
                $b1 = $GLOBALS['ConnIntra']->query($busca);
                fwrite($_SESSION['logfile'], "$busca\r\n") or die("Error escribiendo en el archivo\r\n");
                while ($rowb1 = $b1->fetch_assoc()) {
                    $upd = "INSERT INTO tb_job_filtros (ItemCode, ItemName, StockBodegasActivas, Pendiente, StockProyectado, Buffer, und_redondeo, prod_minima, buffer_manual, stock_max, punto_activacion, ciclo_produccion, factor_fab, mult_ciclos, comentarios, UnidadesRecomendadas, DiasActivacion, fecha, hora) VALUES ('".$fila['ItemCode']."', '".$fila['ItemName']."', '".$fila['StockBodegasActivas']."', '".$fila['Pendiente']."', '".$fila['StockProyectado']."', '".$fila['Buffer']."', '".$rowb1['und_redondeo']."', '".$rowb1['prod_minima']."', '".$rowb1['buffer_manual']."', '".$rowb1['stock_max']."', '".$rowb1['punto_activacion']."', '".$rowb1['ciclo_produccion']."', '".$rowb1['factor_fab']."', '".$rowb1['mult_ciclos']."', '".$rowb1['comentarios']."', '".$rowb1['UnidadesRecomendadas']."', '".$rowb1['DiasActivacion']."','$fecha', '$hora')";
                   $GLOBALS['ConnIntra']->query($upd);
                }
            }
            echo 'Parametros = true', PHP_EOL;
            fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tTabla Parametros realizada correctamente\r\n") or die("Error escribiendo en el archivo\r\n");
        }catch (Exception $e) {
            fwrite($_SESSION['logfile'], "".date("d/m/Y H:i:s")." -\tError Actualziando Tabla Parametros\r\n".$e->getMessage()."\r\n") or die("Error escribiendo en el archivo\r\n");
            echo 'Datos de Parametros = false', PHP_EOL;
        }
    }
    ?>